//Program to Find the Performance Characteristics of Single Phase Transformer By Conducting Open Circuit test and Short Circuit Test
//This program requires user input. A sample problem with user input and output is available in the result files.
//Scilab Version 5.5.2 ; OS:Windows
clc;
clear;
//Getting the Rated values of Single Phase Transformer
disp('Name Plate Details')
cap=input('Enter the rated capacity of Tansformer in KVA:')
pv=input('Enter the primary voltage of a Single Phase Transformer(HV) in Volts:')
pc=cap/pv//calculation of primary current, capacity/Primary voltage
disp(pc, 'The Primary current of transformer =')
sv=input('Enter the Secondary voltage of a Single Phase Transformer(LV) in Volts:')
sc=cap/sv//calculation of secondary current, capacity/secondary voltage
disp(sc, 'The secondary current of transformer =')
//open Circuit Test
//For open circuit test, Consider the LV side as primary, HV side is kept open
disp('Open Circut Test')
v0=sv//open circuit voltage
i0=0.01*sc//for practical case, there will be negligible amount ofopen circuit current
w0=v0*i0//calculation of Primary power, voltage*current
disp(w0, 'The Iron Loss from Open circuit Test W0 = Wi = ')
//Short Circuit Test
//For Short circuit test, Consider the HV side as primary, LV side is shorted
disp('Short Circut Test')
vsc=pv*0.05//for practical case, there will be negligible amount of short circuit voltage
isc=pc//short circuit current
wsc=vsc*isc//calculation of secondary power, voltage*current
disp(wsc, 'The Copper Loss from Open circuit Test Wsc = Wcu = ')
//Predetermine the efficiency
t=1;
pf=input('Enter the power factor = ')
for j=1:length(pf)
//l=input('Enter the fraction of load = ')
i=1;
for l=0:0.1:1
op(i)=cap*l*pf(j)
//disp(op, 'Output Power of Transformer is ')
//total loss in a transformer = copper loss + Iron loss
los(i)=w0+(wsc*l^2)
ip(i)=op(i)+los(i)
//disp(ip, 'Input Power of Transformer is ')
eff(i,t)=(op(i)/ip(i))*100
i=i+1;
//disp(eff, 'Efficiency of Transformer is ')
end
//plotting the curve of the Performannce Characteristics of transformer
//between Output power and Efficiency for different values of fraction of load
t=t+1;
end
disp([op   eff(:,1)   eff(:,2)],'Output     Eff/PF=0.6    EFF/PF=0.8')
plot(op,eff(:,1),op,eff(:,2));
legend('PF=0.6','PF=0.8');
xlabel('Output Power in watts')
ylabel('Efficiency(%)')
title('Performance Characteristics of Single Phase Transformer')

//SAMPLE INPUT and OUTPUT

//Name Plate Details   
//Enter the rated capacity of Tansformer in KVA:3000
//Enter the primary voltage of a Single Phase Transformer(HV) in Volts:230
 
//The Primary current of transformer =   
 
//    13.043478  
//Enter the Secondary voltage of a Single Phase Transformer(LV) in Volts:115
 
// The secondary current of transformer =   
 
//    26.086957  
 
// Open Circut Test   
 
// The Iron Loss from Open circuit Test W0 = Wi =    
 
//    30.  
 
// Short Circut Test   
 
// The Copper Loss from Open circuit Test Wsc = Wcu =    
 
//    150.  
//Enter the power factor = [0.6 0.8]

 //Output     Eff/PF=0.6    EFF/PF=0.8   
 
//    0.       0.           0.         
//    240.     85.106383    88.39779   
//    480.     90.909091    93.023256  
//    720.     92.544987    94.302554  
//    960.     93.023256    94.674556  
//    1200.    93.023256    94.674556  
//    1440.    92.783505    94.488189  
//    1680.    92.409241    94.196804  
//    1920.    91.954023    93.841642  
//    2160.    91.447925    93.445814  
//    2400.    90.909091    93.023256 

//efficieny curve will be obtained in figure
 
